/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.traceroute.MethodListener;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AsynchMethodInvoker
implements Runnable {
    protected Thread thread;
    protected ThreadGroup threadGroup;
    protected Object source;
    protected String method;
    protected MethodListener listener;
    protected Object[] args;

    public AsynchMethodInvoker() {
    }

    public AsynchMethodInvoker(ThreadGroup threadGroup, Object object, String string) {
        this(threadGroup, object, string, null, null);
    }

    public AsynchMethodInvoker(ThreadGroup threadGroup, Object object, String string, MethodListener methodListener) {
        this(threadGroup, object, string, methodListener, null);
    }

    public AsynchMethodInvoker(ThreadGroup threadGroup, Object object, String string, MethodListener methodListener, Object[] objectArray) {
        this.threadGroup = threadGroup;
        this.source = object;
        this.method = string;
        this.listener = methodListener;
        this.args = objectArray;
        this.thread = new Thread(this.threadGroup, this, "AsynchMethodInvoker calling: " + string);
        this.thread.start();
    }

    public void run() {
        block20: {
            try {
                Class<?> clazz = this.source.getClass();
                Method[] methodArray = clazz.getMethods();
                Method method = null;
                int n = 0;
                while (method == null && n < methodArray.length) {
                    if (this.method.equals(methodArray[n].getName())) {
                        method = methodArray[n];
                    }
                    ++n;
                }
                if (method == null) {
                    throw new NoSuchMethodException(this.method);
                }
                Object object = method.invoke(this.source, this.args);
                if (this.listener != null) {
                    this.listener.methodFinished(object);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("ERROR CAUGHT: by AsynchMethodInvoker.run()");
                    System.out.println("ERROR DETAILS: " + noSuchMethodException);
                    System.out.println("Calling " + this.method);
                    System.out.println("ERROR HANDLED: by calling methodFinished with exception");
                }
                if (this.listener != null) {
                    this.listener.methodFinished(noSuchMethodException);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("ERROR CAUGHT: by AsynchMethodInvoker.run()");
                    System.out.println("ERROR DETAILS: " + invocationTargetException);
                    System.out.println("Calling " + this.method);
                    invocationTargetException.getTargetException().printStackTrace();
                    System.out.println("ERROR HANDLED: by calling methodFinished with exception");
                    System.out.println();
                }
                if (this.listener != null) {
                    this.listener.methodFinished(invocationTargetException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println("ERROR CAUGHT: by AsynchMethodInvoker.run()");
                    System.out.println("ERROR DETAILS: " + illegalAccessException);
                    System.out.println("ERROR HANDLED: by calling methodFinished with exception");
                }
                if (this.listener == null) break block20;
                this.listener.methodFinished(illegalAccessException);
            }
        }
        this.thread.stop();
        this.thread = null;
    }

    public void stop() {
        this.thread.stop();
        this.thread = null;
    }
}

